<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Usertag;

trait TraitPostUserTagSetters
{
    use TraitPostUserTagProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setTaggedUserId(string $taggedUserId)
    {
        $this -> taggedUserId = $taggedUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setTaggedInPostId(string $taggedInPostId)
    {
        $this -> taggedInPostId = $taggedInPostId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPostOwnerUserId(string $postOwnerUserId)
    {
        $this -> postOwnerUserId = $postOwnerUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
